;coded by UEZ build 2016-01-09
#pragma compile(Icon, "AutoIt_Main_v10_48x48_only_RGB-A.ico")
#AutoIt3Wrapper_Run_Au3Stripper=y
#Au3Stripper_Parameters=/so /pe /rm
#AutoIt3Wrapper_Run_After=del /f /q "%scriptdir%\%scriptfile%_stripped.au3"

#include <GDIPlus.au3>
#include <GuiConstantsEx.au3>
#include <WindowsConstants.au3>

_GDIPlus_Startup()
Global $hGUI, $iFPS = 0, $iShowFPS = 0, $bExit
Global Const $iW = 800, $iH = 600, $sTitle = "GDI+ Liquid FX v1.0"
AutoItSetOption("GUIOnEventMode", 1)

GDIPlus_Test()

_GDIPlus_Shutdown()


Func GDIPlus_Test()
	$bExit = False
	$hGUI = GUICreate($sTitle, $iW, $iH)
	GUISetState(@SW_SHOW, $hGUI)
;~ 	GUISetCursor(16, 1)

	;create canvas elements
	Local Const $hDC = _WinAPI_GetDC($hGUI)
	Local Const $hHBitmap = _WinAPI_CreateCompatibleBitmap($hDC, $iW, $iH)
	Local Const $hDC_backbuffer = _WinAPI_CreateCompatibleDC($hDC)
	Local Const $DC_obj = _WinAPI_SelectObject($hDC_backbuffer, $hHBitmap)
	Local Const $hCanvas = _GDIPlus_GraphicsCreateFromHDC($hDC_backbuffer)
;~ 	_GDIPlus_GraphicsSetSmoothingMode($hCanvas, $GDIP_SMOOTHINGMODE_HIGHQUALITY)
	_GDIPlus_GraphicsSetPixelOffsetMode($hCanvas, $GDIP_PIXELOFFSETMODE_HIGHQUALITY)

	Local Const $hBitmap = _GDIPlus_BitmapCreateFromScan0($iW, $iH), $hGfx = _GDIPlus_ImageGetGraphicsContext($hBitmap)
	_GDIPlus_GraphicsSetSmoothingMode($hGfx, $GDIP_SMOOTHINGMODE_HIGHQUALITY)
	_GDIPlus_GraphicsSetPixelOffsetMode($hGfx, $GDIP_PIXELOFFSETMODE_HIGHQUALITY)
;~ 	_GDIPlus_GraphicsSetCompositingQuality($hGfx, 2)

	Local Const $hBrush_Clr = _GDIPlus_BrushCreateSolid(0xFFFFFFFF), _
				$hBrush_FPS = _GDIPlus_BrushCreateSolid(0xF0FFFFFF), _
				$hFormat_FPS = _GDIPlus_StringFormatCreate(), _
				$hFamily_FPS = _GDIPlus_FontFamilyCreate("Arial"), _
				$hFont_FPS = _GDIPlus_FontCreate($hFamily_FPS, 8), _
				$tLayout_FPS = _GDIPlus_RectFCreate(0, 0, 60, 16)

	Local Const $hBrush_Balls = _GDIPlus_BrushCreateSolid(0xF0A08040)
	Local Const $hFX_BC = _GDIPlus_EffectCreateBrightnessContrast(0, 92), $hFX_Blur = _GDIPlus_EffectCreateBlur(50)

	$iFPS = 0
	GUISetOnEvent($GUI_EVENT_CLOSE, "_Exit_About")
	AdlibRegister("CalcFPS", 1000)
	Local $i, $iBalls = 22, $aBallsCoords[$iBalls][4], $fBallsSize = 120

	For $i = 0 To $iBalls - 1
		$aBallsCoords[$i][0] = Random(0, $iW - $fBallsSize, 1)
		$aBallsCoords[$i][1] = Random(0, $iH - $fBallsSize, 1)
		$aBallsCoords[$i][2] = Random(-3, 3)
		$aBallsCoords[$i][3] = Random(-3, 3)
	Next

	Do
;~ 		DllCall($__g_hGDIPDll, "int", "GdipFillRectangle", "handle", $hCanvas, "handle", $hBrush_Clr, "float", 0, "float", 0, _
;~ 				"float", $iW, "float", $iH) ;erase canvas background
		_GDIPlus_GraphicsClear($hGfx, 0xFF8070F0)

		For $i = 0 To $iBalls - 1
			DllCall($__g_hGDIPDll, "int", "GdipFillEllipse", "handle", $hGfx, "handle", $hBrush_Balls, _
								   "float", $aBallsCoords[$i][0], "float", $aBallsCoords[$i][1], "float", $fBallsSize, "float", $fBallsSize)

			$aBallsCoords[$i][0] += $aBallsCoords[$i][2]
			$aBallsCoords[$i][1] += $aBallsCoords[$i][3]
			If BitOR($aBallsCoords[$i][0] <= 0, $aBallsCoords[$i][0] + $fBallsSize >= $iW) Then $aBallsCoords[$i][2] *= -1
			If BitOR($aBallsCoords[$i][1] <= 0, $aBallsCoords[$i][1] + $fBallsSize >= $iH) Then $aBallsCoords[$i][3] *= -1
		Next

		_GDIPlus_BitmapApplyEffect($hBitmap, $hFX_Blur)
		_GDIPlus_BitmapApplyEffect($hBitmap, $hFX_BC)
		_GDIPlus_GraphicsDrawImageRect($hCanvas, $hBitmap, 0, 0, $iW, $iH)

		_GDIPlus_GraphicsDrawStringEx($hCanvas, "FPS: " & $iShowFPS, $hFont_FPS, $tLayout_FPS, $hFormat_FPS, $hBrush_FPS) ;draw background message text
		_WinAPI_BitBlt($hDC, 0, 0, $iW, $iH, $hDC_backbuffer, 0, 0, $SRCCOPY) ;blit drawn bitmap to GUI

		$iFPS += 1
		If $bExit Then ExitLoop
	Until Not Sleep(10)

	AdlibUnRegister("CalcFPS")
	;release resources
	_GDIPlus_FontDispose($hFont_FPS)
	_GDIPlus_FontFamilyDispose($hFamily_FPS)
	_GDIPlus_StringFormatDispose($hFormat_FPS)
	_GDIPlus_BrushDispose($hBrush_Clr)
	_GDIPlus_BrushDispose($hBrush_FPS)
	_GDIPlus_BrushDispose($hBrush_Balls)
	_GDIPlus_GraphicsDispose($hGfx)
	_GDIPlus_GraphicsDispose($hCanvas)
	_GDIPlus_ImageDispose($hBitmap)
	_WinAPI_SelectObject($hDC, $DC_obj)
	_WinAPI_DeleteObject($hHBitmap)
	_WinAPI_ReleaseDC($hGUI, $hDC)
	GUIDelete($hGUI)
EndFunc   ;==>GDIPlus_Test


Func _Exit_About()
	$bExit = True
EndFunc   ;==>_Exit_About

Func CalcFPS() ;display FPS
	$iShowFPS = $iFPS
	$iFPS = 0
EndFunc   ;==>CalcFPS